/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater.converter;

import com.sun.tools.tzupdater.TimezoneUpdater;
import com.sun.tools.tzupdater.converter.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import tools.javazic.Main;

public class VanguardToRearguardConverter {
    public static void convert(File file) {
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("Please provide correct path to tzdata root directory");
        }
        for (int i = 0; i < Constants.REARGUARD_FILES.length; ++i) {
            VanguardToRearguardConverter.convertFileFormat(new File(file, Constants.REARGUARD_FILES[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertFileFormat(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (string.contains("Europe/Dublin")) {
                        Constants.cacheDublin = true;
                    }
                    if (string.equals("# Europe")) {
                        Constants.cacheDublin = false;
                    }
                    if (string.startsWith("# Vanguard section") && !Constants.cacheDublin) {
                        stringBuilder.append(VanguardToRearguardConverter.convertVanguardSection(bufferedReader, string));
                    } else if (file.getName().equals("africa") && VanguardToRearguardConverter.isMoroccoRule(string)) {
                        stringBuilder.append((CharSequence)VanguardToRearguardConverter.convertMoroccoRules(bufferedReader, string));
                    } else if (file.getName().equals("asia") && VanguardToRearguardConverter.isJapanRule(string)) {
                        stringBuilder.append(VanguardToRearguardConverter.convertJapanRule(string)).append(Constants.LINE_SEPARATOR);
                    } else if (file.getName().equals("europe") && VanguardToRearguardConverter.isEuropeRules(string)) {
                        stringBuilder.append((CharSequence)VanguardToRearguardConverter.convertEireRules(bufferedReader, string));
                    } else {
                        stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                    }
                    string = bufferedReader.readLine();
                }
                VanguardToRearguardConverter.writeStringToFile(stringBuilder.toString(), file);
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileNotFoundException: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            TimezoneUpdater.remove(file.getParentFile());
            Main.panic("IO error: " + iOException.getMessage());
        }
    }

    private static StringBuilder convertMoroccoRules(BufferedReader bufferedReader, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (string != null) {
            if (string.matches("^Rule(\\s+|\\t+)Morocco(\\s+|\\t+)2013(\\s+|\\t+)2018.*")) {
                string = string.replace("2018", "2017");
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                break;
            }
            if (string.contains("+01/+00")) {
                string = string.replace("+01/+00", "+00/+01").replace("1:00", "0:00");
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                break;
            }
            if (string.matches("^Rule(\\s+|\\t+)Morocco.*?(3:00(\\s+|\\t+)-1:00.*|2:00(\\s+|\\t+)0.*)")) {
                if (string.contains("-1:00")) {
                    string = string.replace("-1:00", "0");
                } else {
                    int n = string.lastIndexOf("0");
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    string = string2 + "1:00" + string3;
                }
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                string = bufferedReader.readLine();
                continue;
            }
            stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
            break;
        }
        return stringBuilder;
    }

    private static boolean isMoroccoRule(String string) {
        return string.matches("^Rule(\\s+|\\t+)Morocco(\\s+|\\t+)2013(\\s+|\\t+)2018.*") || string.matches("^Rule(\\s+|\\t+)Morocco.*?(3:00(\\s+|\\t+)-1:00.*|2:00(\\s+|\\t+)0.*)") || string.matches("^(\\s+|\\t+)\\s?1:00(\\s+|\\t+)Morocco(\\s+|\\t+)\\+01/\\+00");
    }

    private static StringBuilder convertEireRules(BufferedReader bufferedReader, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (VanguardToRearguardConverter.isEireRuleLine(string)) {
            stringBuilder.append(VanguardToRearguardConverter.commentLine(string)).append(Constants.LINE_SEPARATOR);
            for (int i = 0; i < 6; ++i) {
                stringBuilder.append(VanguardToRearguardConverter.commentLine(bufferedReader.readLine())).append(Constants.LINE_SEPARATOR);
            }
        } else if (string.equals("# The next line is for when negative SAVE values are used.") || string.equals("# Vanguard section, for zic and other parsers that support negative DST.")) {
            stringBuilder.append(string).append(Constants.LINE_SEPARATOR).append(VanguardToRearguardConverter.commentLine(bufferedReader.readLine())).append(Constants.LINE_SEPARATOR);
        } else if (string.equals("# These three lines are for when SAVE values are always nonnegative.") || string.equals("# Rearguard section, for parsers lacking negative DST; see ziguard.awk.")) {
            stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
            for (int i = 0; i < 3; ++i) {
                stringBuilder.append(VanguardToRearguardConverter.unCommentLine(bufferedReader.readLine())).append(Constants.LINE_SEPARATOR);
            }
        } else if (string.equals("# End of rearguard section.")) {
            stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
        }
        return stringBuilder;
    }

    private static boolean isEuropeRules(String string) {
        return VanguardToRearguardConverter.isEireRuleLine(string) || string.equals("# The next line is for when negative SAVE values are used.") || string.equals("# These three lines are for when SAVE values are always nonnegative.") || string.equals("# Vanguard section, for zic and other parsers that support negative DST.") || string.equals("# Rearguard section, for parsers lacking negative DST; see ziguard.awk.") || string.equals("# End of rearguard section.");
    }

    private static boolean isEireRuleLine(String string) {
        return string.matches("^Rule(\\s+|\\t+)Eire(\\s+|\\t+)[1][9]\\d{2}.*");
    }

    private static String convertJapanRule(String string) {
        return string.replace("Sat>=8", "Sun>=9").replace("25:00", " 1:00");
    }

    private static boolean isJapanRule(String string) {
        return string.matches("^Rule(\\s+|\\t+).*?Sat>=8(\\s+|\\t+)25:00.*");
    }

    private static void writeStringToFile(String string, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write(string);
                bufferedWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            TimezoneUpdater.remove(file.getParentFile());
            Main.panic("IO error: " + iOException.getMessage());
        }
    }

    private static String convertVanguardSection(BufferedReader bufferedReader, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        while (string != null) {
            if (bl && !VanguardToRearguardConverter.vanguardEnd(string)) {
                stringBuilder.append("#").append(string).append(Constants.LINE_SEPARATOR);
                string = bufferedReader.readLine();
                continue;
            }
            if (bl2 && !VanguardToRearguardConverter.rearguardEnd(string)) {
                if (string.matches("^#(\\s?Rule(\\s{4,}|\\t+)).*|^#(\\s{12,}|\\t{3,})[0-9]:\\d+.*")) {
                    string = VanguardToRearguardConverter.unCommentLine(string);
                }
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                string = bufferedReader.readLine();
                continue;
            }
            if (VanguardToRearguardConverter.rearguardEnd(string)) {
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                break;
            }
            if (VanguardToRearguardConverter.rearguardStart(string)) {
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                bl2 = true;
                bl = false;
            } else if (VanguardToRearguardConverter.vanguardStart(string)) {
                stringBuilder.append(string).append(Constants.LINE_SEPARATOR);
                bl2 = false;
                bl = true;
            }
            string = bufferedReader.readLine();
        }
        return stringBuilder.toString();
    }

    private static boolean vanguardStart(String string) {
        return string.startsWith("# Vanguard section");
    }

    private static boolean rearguardStart(String string) {
        return string.startsWith("# Rearguard section");
    }

    private static boolean vanguardEnd(String string) {
        return string.startsWith("# Rearguard section");
    }

    private static boolean rearguardEnd(String string) {
        return string.startsWith("# End of rearguard");
    }

    private static String commentLine(String string) {
        return "#" + string;
    }

    private static String unCommentLine(String string) {
        return string.replace("#", "");
    }
}

